/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package productsFinal;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Objects;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Product implements Item, Serializable {

    private String brand;
    private Description description = new Description();
    private int colour;
    private int ID;
    private static int nextProductNumber =1;//Start the product number at 1
    final String name;
    protected double price;

    public Product(String name) {
        this.name=name;
        this.ID = nextProductNumber++;
    }

    public Product(String name, String description, double price) {
        this(name);
        enterDescription(description);
        setPrice(price);
    }

    public int getID() {
        return ID;
    }

    //Getter and Setter for colour
    public void setColour(String name) {
        this.colour = toColour(name); 
    }
    public String getColour() {
        return toName(this.colour);
    }

    public final void enterDescription(String comment, String country, int height, int weight) {
        this.description = new Description(comment, country, height, weight);
    }

    public final void enterDescription(String comment) {
        this.description = new Description(comment);
    }

    //This method will be used whenever anyone want to print out the details of a product.
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getPrice());
    }

    public String getName() {
        return name;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    protected String getDescription() {
        return description.comments
                + " Country: " + description.country
                + " Height: " + description.height
                + " Weight: " + description.weight;
    }

    public String getPrice() {
        //Define our format as the default currency.
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        
        //return the price in the default format.
        return defaultFormat.format(price);
    }

    public void setPrice(double price) {
            if (price >= 0) {
                this.price = price;
            } else {//Price is negative
                System.out.println("You can not enter a negative price.");
            }
    }
    
    @Override
    public String toString(){
        return "ID: "+ID
        +"\nName: " + getName()
        +"\nDescription: " + getDescription()
        +"\nPrice: " + getPrice();
    }
    
    @Override
    public boolean equals(Object o){
        if (o instanceof Product){
            return ((Product) o).name.equals(this.name);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }
    
    public static String toName(int colour){
        switch (colour) {
            case 0xe6194b: 
                return "Red";
            case 0x0082c8: 
                return "Blue";
            case 0x000000:
                return "Black";
            case 0x3cb44b: 
                return "Green";
            default:
                return "Internal Error, colour not recognised.";
        } 
    }
    
    public static int toColour(String colour) {
        switch (colour) {
            case "Red": 
                return 0xe6194b;
            case "Blue":
                return 0x0082c8;
            case "Black":
                return 0x000000;
            case "Green":
                return 0x3cb44b;
            default:
                System.out.println("The products colour must be either Red, Blue, Black or Green");
                return 0;
        }
    }
    
    public static int getNextProductNumber(){
        //print out the ID and name of the product first
//        System.out.println("Product ID: "+this.ID);
//        System.out.println("Name: "+this.getName());
        return nextProductNumber;
    }
    
    public static void resetNextProductNumber(){
        nextProductNumber = 1;
    }
    
}
